@php
    use Illuminate\Support\Facades\Request;

    $pos_layout = Request::segment(1) === 'pos' &&
                 (Request::segment(2) === 'create' || Request::segment(3) === 'edit' || Request::segment(2) === 'payment');

    $currency = session('currency');
    $business = session('business');
    $theme_color = $business['theme_color'] ?? 'blue-light';
    $is_rtl = in_array(session()->get('user.language', config('app.locale')), config('constants.langs_rtl'));
    $is_mobile = isMobile();
    $is_localhost = in_array($_SERVER['REMOTE_ADDR'], ['127.0.0.1', '::1']);
    $asset_v = config('app.asset_version', 1);

    // --------- SUPER-ROBUST Supplier detection (single-file) ----------
    $u = auth()->user();
    $is_supplier_user = false;

    if ($u) {
        // 1) Spatie roles (any guard)
        $has_role = false;
        try {
            if (method_exists($u, 'getRoleNames')) {
                $roles = collect($u->getRoleNames())->map(fn($r)=>strtolower(trim($r)));
                $has_role = $roles->contains('supplier') || $roles->contains('suppliers');
            } elseif (property_exists($u, 'roles') && $u->roles) {
                $roles = collect($u->roles)->pluck('name')->map(fn($r)=>strtolower(trim($r)));
                $has_role = $roles->contains('supplier') || $roles->contains('suppliers');
            }
        } catch (\Throwable $e) {}

        // 2) Typical app flags / types
        $user_type = strtolower((string)($u->user_type ?? ''));
        $by_type = in_array($user_type, ['supplier','supplier_user','user_supplier'], true);

        // 3) Linkage hint (you previously hit an error about this)
        $by_link = !empty($u->supplier_contact_id ?? null);

        // 4) Session mirrors (some apps stash role/type in session)
        $sess = collect((array)session('user', []));
        $sess_roles = collect((array)$sess->get('roles', []))
            ->map(fn($r)=>is_array($r)?strtolower($r['name']??''):strtolower((string)$r));
        $sess_has_role = $sess_roles->contains('supplier') || $sess_roles->contains('suppliers');
        $sess_type = strtolower((string)$sess->get('user_type', ''));
        $sess_link = !empty($sess->get('supplier_contact_id', null));

        // 5) Permission pattern (read-own only)
        $perm_supplierish = false;
        try {
            $perm_supplierish = (
                ($u->can('supplier.view_own') || $u->can('purchase.view_own') || $u->can('view_own_purchase'))
                && !$u->can('supplier.view') && !$u->can('customer.view') && !$u->can('sell.view')
            );
        } catch (\Throwable $e) {}

        $is_supplier_user = $has_role || $by_type || $by_link || $sess_has_role || $sess_link || in_array($sess_type, ['supplier','supplier_user','user_supplier'], true) || $perm_supplierish;
    }
@endphp

<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ $is_rtl ? 'rtl' : 'ltr' }}" class="tw-bg-white tw-scroll-smooth">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title') - {{ $business['name'] ?? config('app.name') }}</title>

    @include('layouts.partials.css')
    @include('layouts.partials.extracss')
    @yield('css')

    <style>
        .dataTables_length { margin-top: 70px !important; height: 99px !important; }
        @media print { #scrollable-container { overflow: visible !important; height: auto !important; } }
        .small-view-side-active { display: grid !important; z-index: 1000; position: absolute; }
        .overlay { width: 100vw; height: 100vh; background: rgba(0,0,0,.8); position: fixed; top:0; left:0; display:none; z-index:20; }
        .tw-dw-btn.tw-dw-btn-xs.tw-dw-btn-outline { width: max-content; margin: 2px; }
        #scrollable-container { position: relative; }
    </style>

    {{-- Late, high-specificity CSS kill-switch for Supplier --}}
    @if( !$pos_layout)
   
    </style>
    @endif
</head>
<body class="tw-font-sans tw-antialiased tw-text-gray-900 tw-bg-gray-100 {{ $pos_layout ? 'hold-transition lockscreen' : 'hold-transition skin-' . $theme_color . ' sidebar-mini' }} {{ $is_supplier_user ? 'supplier-mode' : '' }}">
    <div class="tw-flex">

        {{-- Keep collapse preference for non-suppliers --}}
        <script defer>
            document.addEventListener("DOMContentLoaded", () => {
                if (localStorage.getItem("upos_sidebar_collapse") === 'true') {
                    document.body.classList.add("sidebar-collapse");
                }
            });
        </script>

        {{-- HARD removal on Supplier accounts (handles cached HTML / unexpected partials) --}}
        @if($is_supplier_user && !$pos_layout)
        <script>
        (function () {
            function nukeSidebar() {
                // Force collapsed state for any AdminLTE-like skins
                document.body.classList.add('sidebar-collapse');
                // Remove any existing sidebar elements
                document.querySelectorAll('aside.side-bar, aside.small-view-side-active, .main-sidebar, #side-bar, .small-view-button')
                    .forEach(el => { try { el.remove(); } catch(e) {} });
            }
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', nukeSidebar);
            } else {
                nukeSidebar();
            }
        })();
        </script>
        @endif

        {{-- Render sidebar ONLY for non-suppliers and non-POS pages --}}
        @unless($pos_layout || $is_supplier_user)
            @include('layouts.partials.sidebar')
        @endunless

        @if ($is_localhost)
            <input type="hidden" id="__is_localhost" value="true">
        @endif

        <!-- Currency/system info -->
        <input type="hidden" id="__code" value="{{ $currency['code'] ?? '' }}">
        <input type="hidden" id="__symbol" value="{{ $currency['symbol'] ?? '' }}">
        <input type="hidden" id="__thousand" value="{{ $currency['thousand_separator'] ?? '' }}">
        <input type="hidden" id="__decimal" value="{{ $currency['decimal_separator'] ?? '' }}">
        <input type="hidden" id="__symbol_placement" value="{{ $business['currency_symbol_placement'] ?? 'before' }}">
        <input type="hidden" id="__precision" value="{{ $business['currency_precision'] ?? 2 }}">
        <input type="hidden" id="__quantity_precision" value="{{ $business['quantity_precision'] ?? 2 }}">

        @can('view_export_buttons')
            <input type="hidden" id="view_export_buttons">
        @endcan

        @if ($is_mobile)
            <input type="hidden" id="__is_mobile">
        @endif

        @if (session('status'))
            <input type="hidden" id="status_span" data-status="{{ session('status.success') }}" data-msg="{{ session('status.msg') }}">
        @endif

        <main class="tw-flex tw-flex-col tw-flex-1 tw-h-full tw-min-w-0 tw-bg-gray-100">
            @if (!$pos_layout)
                @include('layouts.partials.header')
            @else
                @include('layouts.partials.header-pos')
            @endif

            <div id="app">@yield('vue')</div>

            <div class="tw-flex-1 tw-overflow-y-auto tw-h-screen" id="scrollable-container">
                @yield('content')

                @if (!$pos_layout)
                    @include('layouts.partials.footer')
                @else
                    @include('layouts.partials.footer_pos')
                @endif
            </div>

            <div class="scrolltop no-print">
                <div class="scroll icon"><i class="fas fa-angle-up"></i></div>
            </div>

            @if (config('constants.iraqi_selling_price_adjustment'))
                <input type="hidden" id="iraqi_selling_price_adjustment">
            @endif

            <section class="invoice print_section" id="receipt_section"></section>
        </main>

        @include('home.todays_profit_modal')

        <!-- Audio -->
        <audio preload="none" id="success-audio">
            <source src="{{ asset('/audio/success.mp3?v=1.1') }}" type="audio/ogg">
        </audio>
        <audio preload="none" id="error-audio">
            <source src="{{ asset('/audio/error.mp3?v=1.1') }}" type="audio/ogg">
        </audio>
        <audio preload="none" id="warning-audio">
            <source src="{{ asset('/audio/warning.mp3?v=1.1') }}" type="audio/ogg">
        </audio>

        @if (!empty($__additional_html))
            {!! $__additional_html !!}
        @endif
<link rel="manifest" href="{{ asset('manifest.json') }}">

<link rel="manifest" href="{{ asset('manifest.json') }}">
<script>
    if ('serviceWorker' in navigator) {
        window.addEventListener('load', () => {
            navigator.serviceWorker.register('{{ asset('service-worker.js') }}');
        });
    }
</script>
        <script src="https://unpkg.com/dexie@3/dist/dexie.umd.js"></script>
        @include('layouts.partials.javascripts')

        {{-- Global AI chat widget --}}
        @include('layouts.partials.ai_widget')

        <div class="modal fade view_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

        @if (!empty($__additional_views) && is_array($__additional_views))
            @foreach ($__additional_views as $additional_view)
                @includeIf($additional_view)
            @endforeach
        @endif

        <div class="overlay tw-hidden"></div>
    </div>
</body>
</html>
